/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.integrator.VWAdaptorPropertyPanel;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Level;
import filenet.vw.integrator.IVWAdaptorControl;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class VWAdaptorNode
extends VWTaskBaseNode {
    private VWAdaptorPropertyPanel m_propertyPanel = null;
    private IVWAdaptorControl m_adaptor = null;
    private StatusMonitor m_statusMonitor = null;
    private StatisticsMonitor m_statisticsMonitor = null;
    protected static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("adapter_32.gif");
    protected static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("adapter_16.gif");
    protected static final ImageIcon nodeIconS32 = VWImageLoader.createImageIcon("adapter_stop_32.gif");
    protected static final ImageIcon nodeIconS16 = VWImageLoader.createImageIcon("adapter_stop_16.gif");
    private boolean bWebServices = false;
    private static final String[] actions = new String[]{VWTaskActionCommand.START, VWTaskActionCommand.STOP, VWTaskActionCommand.REFRESH_COMPONENT_CONFIG, VWTaskActionCommand.RESET_STATISTICS, "Add Separator", VWTaskActionCommand.HELP};
    private static final String[] wsRequest_actions = new String[]{VWTaskActionCommand.START, VWTaskActionCommand.STOP, VWTaskActionCommand.RESET_STATISTICS, "Add Separator", VWTaskActionCommand.HELP};

    protected boolean isWebServices(IVWAdaptorControl adaptor) {
        try {
            return adaptor != null && adaptor.getName().startsWith("WSRequest");
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public VWAdaptorNode(IVWAdaptorControl adaptor) throws Exception {
        super(adaptor.getName(), 19);
        this.bWebServices = this.isWebServices(adaptor);
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
        this.m_propertyPanel = new VWAdaptorPropertyPanel(this, adaptor.getComponentDescriptor());
        this.getContentPane().setPropertyPanel(this.m_propertyPanel);
        this.setAdaptor(adaptor);
    }

    public void refresh() {
        try {
            if (this.isStarted()) {
                this.startMonitorThreads();
            } else {
                this.m_propertyPanel.setAdaptorStatus(this.m_adaptor.status());
            }
            if (!this.isDirty()) {
                this.m_propertyPanel.refresh(this.m_adaptor.getComponentDescriptor());
            } else {
                this.m_propertyPanel.refresh();
            }
        }
        catch (Exception e) {
            this.displayError(e);
        }
    }

    public void setAdaptor(IVWAdaptorControl adaptor) throws RemoteException {
        this.m_adaptor = adaptor;
        this.setName(this.m_adaptor.getName());
        this.refresh();
    }

    public void start() {
        try {
            if (!this.m_adaptor.adaptorIsStarted()) {
                this.writeMessage(Level.INFO, VWResource.StartingAdaptor);
                this.m_adaptor.start();
                this.writeMessage(Level.INFO, VWResource.AdaptorStarted);
                this.startMonitorThreads();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
            this.stopMonitorThreads();
        }
        this.m_propertyPanel.refresh();
    }

    public void stop() {
        try {
            if (this.m_adaptor.adaptorIsStarted()) {
                this.writeMessage(Level.INFO, VWResource.StoppingAdaptor);
                this.m_adaptor.stop();
                this.writeMessage(Level.INFO, VWResource.AdaptorStopped);
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
        this.stopMonitorThreads();
        this.m_propertyPanel.refresh();
    }

    private void refreshConfiguration() {
        try {
            this.writeMessage(Level.INFO, VWResource.StoppingAdaptor);
            this.m_adaptor.refresh();
            this.writeMessage(Level.INFO, VWResource.StartingAdaptor);
            this.refresh();
        }
        catch (Exception e) {
            this.displayError(e);
        }
    }

    public boolean isStarted() {
        try {
            return this.m_adaptor != null && this.m_adaptor.adaptorIsStarted();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public String getAdaptorType() {
        if (this.m_propertyPanel != null) {
            return this.m_propertyPanel.getAdaptorType();
        }
        return null;
    }

    protected String getServiceDescriptor() throws RemoteException {
        return this.m_adaptor.getComponentDescriptor();
    }

    protected void setComponentDescriptor(String descriptor) throws RemoteException {
        VWDebug.logInfo("Setting component descriptor for adaptor: " + this.getName());
        VWDebug.logInfo("New descriptor: " + descriptor);
        this.m_adaptor.setComponentDescriptor(descriptor);
    }

    public Icon getIcon16() {
        if (this.isStarted()) {
            return nodeIcon16;
        }
        return nodeIconS16;
    }

    public Icon getIcon32() {
        if (this.isStarted()) {
            return nodeIcon32;
        }
        return nodeIconS32;
    }

    public String toString() {
        return this.getName();
    }

    public void displayHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_TaskManager + "cm_comp.htm");
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.START) == 0) {
                this.start();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.STOP) == 0) {
                this.stop();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.RESET_STATISTICS) == 0) {
                this.m_adaptor.resetCallTimeStatistics();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.REFRESH_COMPONENT_CONFIG) == 0) {
                this.refreshConfiguration();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.REFRESH) == 0) {
                this.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.displayHelp();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public String[] getActions() {
        if (this.bWebServices) {
            return wsRequest_actions;
        }
        return actions;
    }

    public boolean isActionEnabled(String actionCMD) {
        if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.START) == 0) {
            return this.showStartIcon();
        }
        if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.STOP) == 0) {
            return this.showStopIcon();
        }
        if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.RESET_STATISTICS) == 0) {
            return this.showStopIcon();
        }
        return true;
    }

    public boolean showStartIcon() {
        return !this.isStarted();
    }

    public boolean showStopIcon() {
        return this.isStarted();
    }

    public boolean showDeleteIcon() {
        return false;
    }

    public boolean showPropertyIcon() {
        return true;
    }

    public boolean showCommitIcon() {
        return false;
    }

    public boolean showDiscardIcon() {
        return false;
    }

    protected void startMonitorThreads() {
        if (this.m_statusMonitor == null || !this.m_statusMonitor.isRunning()) {
            this.m_statusMonitor = new StatusMonitor();
            this.m_statusMonitor.start();
        }
        if (this.m_statisticsMonitor == null || !this.m_statisticsMonitor.isRunning()) {
            this.m_statisticsMonitor = new StatisticsMonitor();
            this.m_statisticsMonitor.start();
        }
    }

    protected void stopMonitorThreads() {
        if (this.m_statusMonitor != null) {
            this.m_statusMonitor.stopIt();
            this.m_statusMonitor = null;
        }
        if (this.m_statisticsMonitor != null) {
            this.m_statisticsMonitor.stopIt();
            this.m_statisticsMonitor = null;
        }
    }

    private class StatisticsMonitor
    extends Thread {
        boolean stopped = true;

        private StatisticsMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.stopped = false;
                while (!this.stopped) {
                    VWAdaptorNode.this.m_propertyPanel.setAvgCallsMinute(VWAdaptorNode.this.m_adaptor.getAverageCallsPerMinute());
                    VWAdaptorNode.this.m_propertyPanel.setAvgCallTime(VWAdaptorNode.this.m_adaptor.getAverageCallTimeMillis());
                    VWAdaptorNode.this.m_propertyPanel.setAdaptorStatus(VWAdaptorNode.this.m_adaptor == null ? "" : VWAdaptorNode.this.m_adaptor.status());
                    Thread.sleep(1000L);
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.stopped = true;
            }
        }

        public void stopIt() {
            this.stopped = true;
            try {
                VWAdaptorNode.this.m_propertyPanel.setAdaptorStatus(VWAdaptorNode.this.m_adaptor == null ? "" : VWAdaptorNode.this.m_adaptor.status());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public boolean isRunning() {
            return !this.stopped;
        }
    }

    private class StatusMonitor
    extends Thread {
        boolean stopped = true;

        private StatusMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.stopped = false;
                while (VWAdaptorNode.this.m_adaptor.adaptorIsStarted() && !this.stopped) {
                    Thread.sleep(500L);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (!VWAdaptorNode.this.m_adaptor.adaptorIsStarted()) {
                    VWAdaptorNode.this.refresh();
                    VWAdaptorNode.this.nodeChanged();
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.stopped = true;
            }
        }

        public void stopIt() {
            this.stopped = true;
        }

        public boolean isRunning() {
            return !this.stopped;
        }
    }
}

